(in-package "CL-USER")

;; (load "unroll")

(defvar *constrs* nil)
(defvar *vars* nil)
(defvar *tvars* 0)
(defvar *rp* t)

(declaim (ftype (function (fixnum fixnum) form-vec) ps-new-temp-var))
(defun ps-new-temp-var (step bits)
  (let ((vname (read-from-string (format nil "_T~A" (incf *tvars*)))))
    (if (= bits 1)
	(let ((v (make-unique-formula :fn 'var :args (list vname step 0))))
	  (setf *vars* (cons v *vars*))
	  v)
      (let ((vec (new-vec bits)))
	(dotimes (i bits (make-unique-vec vec))
	  (let ((v (make-unique-formula :fn 'var :args (list vname step i))))
	    (vec-set-bit vec i v)
	    (setf *vars* (cons v *vars*))))))))
  
(declaim (ftype (function ((or (cons formula (cons formula null))
			       (cons vec     (cons vec     null))
			       (cons mem     (cons mem     null))))
			  formula)
		ps-equals-form))
(defun ps-equals-form (args)
  (let ((arg1 (first args))
	(arg2 (second args))) 
    (cond ((not (mem-p arg1)) (equals-form args))
	  ((eq arg1 arg2) *one*)
	  (t
	   (let ((nargs nil))
	     (dotimes (i (mem-num-words arg1) (sb-and-form nargs))
	       (dotimes (j (mem-wordsize arg1))
		 (setf nargs (cons (sb-equiv-form (list (mem-get-bit arg1 i j)
							(mem-get-bit arg2 i j)))
				   nargs)))))))))

(declaim (ftype (or (function ((cons formula (cons formula (cons formula null)))) formula)
		    (function ((cons formula (cons vec     (cons vec     null)))) vec)
		    (function ((cons formula (cons mem     (cons mem     null)))) mem))
 		ps-if-form))
(defun ps-if-form (args)
    (cond ((not (mem-p (second args)))
	   (if-form args))
	  (t
	   (let* ((switch? (eq (formula-fn (first args)) 'not))
		  (ifexp (if switch? (sb-not-form (first args)) (first args)))
		  (thenexp (if switch? (third args) (second args)))
		  (elseexp (if switch? (second args) (third args))))
	     (cond ((eq ifexp *one*) thenexp)
		   ((eq ifexp *zero*) elseexp)
		   ((eq thenexp elseexp) thenexp)
		   (t
		    (let ((mem (new-mem (mem-num-words thenexp) (mem-wordsize thenexp))))
		      (dotimes (i (mem-num-words thenexp) mem)
			(dotimes (j (mem-wordsize thenexp))
			  (mem-set-bit mem i j
				       (sb-if-form ifexp
						   (mem-get-bit thenexp i j)
						   (mem-get-bit elseexp i j))))))))))))

;;;;;;; memory rewriting ;;;;;;;

(declaim (ftype (function (list) null) clear-var-slots))
(defun clear-var-slots (vars)
  (when (consp vars)
    (setf (formula-slot1 (car vars)) nil)
    (setf (formula-slot2 (car vars)) nil)
    (clear-var-slots (cdr vars)))
  nil)

;;; find-slot-residue: helpful for debugging.
;;; checks if any slot1s or slot2s are set when they shouldn't be.

(declaim (ftype (function (t) null) find-slot-residue1))
(defun find-slot-residue1 (form)
  (cond ((not (formula-p form))
	 nil)
	((eq (formula-slot1 form) 'fsr)
	 nil)
	((formula-slot1 form)
	 (break "residue: slot1.")
	 nil)
	((formula-slot2 form)
	 (break "residue: slot2.")
	 nil)
	(t
	 (setf (formula-slot1 form) 'fsr)
	 (dolist (arg (formula-args form)) (find-slot-residue1 arg)))))

(declaim (ftype (function (formula) t) find-slot-residue))
(defun find-slot-residue (form)
  (find-slot-residue1 form)
  (clear-slot1 form))

(declaim (ftype (function (formula formula boolean) (values formula boolean))))
(defun mr-return (form nform cp)
  (setf (formula-slot1 form) (cons nform cp))
  (values nform cp))

(declaim (ftype (function (formula form-vec form-vec) formula) set-rewrite1))
(defun set-rewrite1 (mem addr val)
  (case (formula-fn mem)
    (var (set-form mem addr val))
    (if (set-form mem addr val)
	#|(ps-if-form (list (first (formula-args mem))
			  (set-rewrite1 (second (formula-args mem)) addr val)
			  (set-rewrite1 (third (formula-args mem)) addr val)))|#)
    (set (let* ((sargs (formula-args mem))
		(smem (first sargs))
		(saddr (second sargs))
		(sval (third sargs))
		(eqform (ps-equals-form (list addr saddr))))
	   (cond ((eq eqform *one*) (set-rewrite1 smem addr val))
		 ((and (eq eqform *zero*)
		       (> (formula-value addr) (formula-value saddr)))
		  (set-form (set-rewrite1 smem addr val) saddr sval))
		 (t (set-form mem addr val)))))
    (_zero_mem (set-form mem addr val))
    (otherwise 
     (break (format nil "~&set-rewrite1: unexpected function, ~A~%" (formula-fn mem)))
     (the formula *junk*))))

(declaim (ftype (function (formula) (values formula boolean)) set-rewrite))
(defun set-rewrite (form)
  (let ((mem (first (formula-args form)))
	(addr (second (formula-args form)))
	(val (third (formula-args form))))
    (case (formula-fn mem)
      (var (mr-return form form nil))
      (if (mr-return form form nil)
	  #|(mr-return form
		     (ps-if-form (list (first (formula-args mem))
				    (set-rewrite1 (second (formula-args mem)) addr val)
				    (set-rewrite1 (third (formula-args mem)) addr val)))
		     t)|#)
      (set (let* ((sargs (formula-args mem))
		  (smem (first sargs))
		  (saddr (second sargs))
		  (sval (third sargs))
		  (eqform (ps-equals-form (list addr saddr))))
	     (cond ((eq eqform *one*) (mr-return form (set-rewrite1 smem addr val) t))
		   ((and (eq eqform *zero*)
			 (< (formula-value addr) (formula-value saddr)))
		    (mr-return form (set-form (set-rewrite1 smem addr val) saddr sval) t))
		   (t (mr-return form form nil)))))
      (_zero_mem (mr-return form form nil))
      (otherwise (break (format nil "~&set-rewrite1: unexpected function, ~A~%" (formula-fn mem)))
		 (values (the formula *junk*) t)))))

(declaim (ftype (function (formula form-vec fixnum) form-vec) get-rewrite1))
(defun get-rewrite1 (mem addr nw)
  (case (formula-fn mem)
    (var (get-form mem addr nw))
    (if (if-form (list (first (formula-args mem))
		       (get-rewrite1 (second (formula-args mem)) addr nw)
		       (get-rewrite1 (third (formula-args mem)) addr nw))))
    (set (let* ((sargs (formula-args mem))
		(saddr (the form-vec (second sargs)))
		(eqform (ps-equals-form (list addr saddr))))
	   (if-form (list eqform
			  (the form-vec (third sargs))
			  (get-rewrite1 (first sargs) addr nw)))))
    (_zero_mem (const-form (n-copies 0 (second (formula-args mem)))))
    (otherwise (break (format nil "~&get-rewrite1: unexpected function, ~A~%" (formula-fn mem)))
	       (the formula *junk*))))

(declaim (ftype (function (formula) form-vec) get-rewrite))
(defun get-rewrite (form)
  (let ((mem (first (formula-args form)))
	(addr (second (formula-args form)))
	(nw (third (formula-args form))))
    (case (formula-fn mem)
      (var (mr-return form form nil))
      (if (mr-return form
		       (if-form (list (first (formula-args mem))
				      (get-rewrite1 (second (formula-args mem))
						    addr
						    nw)
				      (get-rewrite1 (third (formula-args mem))
						    addr
						    nw)))
		     t))
      (set (let* ((sargs (formula-args mem))
		  (saddr (second sargs))
 		  (eqform (ps-equals-form (list addr saddr))))
	     (mr-return form
			(if-form (list eqform
				       (third sargs)
				       (get-rewrite1 (first sargs) addr nw)))
			t)))
      (_zero_mem (mr-return form (const-form (n-copies 0 (second (formula-args mem))))
			    t))
      (otherwise (break (format nil "~&get-rewrite: unexpected function, ~A~%" (formula-fn mem)))
		 (values (the formula *junk*) t)))))

(defun mem-rewrite-list1 (lst changed)
  (if (endp lst)
      (values nil changed)
    (multiple-value-bind
	(ncar chng-car)
	(mem-rewrite1 (car lst))
      (multiple-value-bind
	  (ncdr chng-cdr)
	  (mem-rewrite-list1 (cdr lst) (or changed chng-car))
	(values (cons ncar ncdr) chng-cdr)))))

(defun mem-rewrite-list (lst)
  (mem-rewrite-list1 lst nil))

(defun mem-rewrite2 (construct form)
  (multiple-value-bind
      (nargs cp)
      (mem-rewrite-list (formula-args form))
    (cond (cp (let ((nform (funcall construct nargs)))
		(setf (formula-slot1 form) (cons nform t))
		(values nform t)))
	  (t (setf (formula-slot1 form) (cons form nil))
	     (values form nil)))))

(defun mem-rewrite1 (form)
  (cond ((vec-p form)
	 (let* ((vb (vec-num-bits form))
		(vec (new-vec vb))
		(cp nil))
	   (dotimes (i vb (values (if cp (make-unique-vec vec) form) cp))
	     (multiple-value-bind
		 (nbit ncp)
		 (mem-rewrite1 (vec-get-bit form i))
	       (or cp (setf cp ncp))
	       (vec-set-bit vec i nbit)))))
	((formula-slot1 form)
	 (values (car (formula-slot1 form))
		 (cdr (formula-slot1 form))))
	(t
	 (case (formula-fn form)
	   (var (mr-return form form nil))
	   (and (mem-rewrite2 #'sb-and-form form))
	   (<-> (mem-rewrite2 #'sb-equiv-form form))
	   (not (multiple-value-bind
		    (narg cp)
		    (mem-rewrite1 (first (formula-args form)))
		  (cond (cp (mr-return form (sb-not-form narg) t))
			(t (mr-return form form nil)))))
	   (bit (let ((args (formula-args form)))
		  (multiple-value-bind
		      (narg cp)
		      (mem-rewrite1 (first args))
		    (cond (cp (mr-return form (get-bit narg (second args)) t))
			  (t  (mr-return form form nil))))))
	   (= (mem-rewrite2 #'equals-form form))
	   (if (mem-rewrite2 #'if-form form))
	   (get (multiple-value-bind
		    (nargs cp)
		    (mem-rewrite-list (butlast (formula-args form)))
		  (if cp
		      (mr-return form
				 (get-rewrite1 (first nargs) (second nargs) (third (formula-args form)))
				 t)
		    (get-rewrite form))))
	   (set (multiple-value-bind
		    (nargs cp)
		    (mem-rewrite-list (formula-args form))
		  (if cp
		      (mr-return form (apply #'set-form nargs) t)
		    (mr-return form form nil))))		 
	   #|(mr-return form
	   (set-rewrite1 (first nargs) (second nargs) (third nargs))
	   t)
	   (set-rewrite form))))|#
	   (const (mr-return form form nil))
	   ;;(cat (mem-rewrite2 (lambda (x) (cat-form (formula-type form) x)) form))
	   (_zero_mem (mr-return form form nil))
	   (mv (mem-rewrite2 (lambda (x) (mv-form (formula-type form) x)) form))
	   (otherwise
	    (break (format nil "~&mem-rewrite: unknown function ~A.~%" (formula-fn form))))))))
  
(defun mem-rewrite (form)
  (scrub-slots form)
  (let ((nform (mem-rewrite1 form)))
    (clear-slot1 form)
    (scrub-slots nform)
    nform))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(declaim (ftype (function (mem fixnum (cons (cons formula fixnum) list)) form-vec) simplify-get))
(defun simplify-get (mem nw cv-pairs)
  (let* ((ws (mem-wordsize mem))
	 (v (ps-new-temp-var 0 (* ws nw))))
    (if (endp (cdr cv-pairs))
	(mem-get-word mem (cdar cv-pairs))
      (dolist (cv cv-pairs v)
	(declare (type (cons formula fixnum) cv))
	(setf *constrs*
	      (cons (sb-or-form (list (sb-not-form (car cv))
				      (ps-equals-form (list v (mem-get-word mem (cdr cv))))))
		    *constrs*))))))

(declaim (ftype (function (fixnum fixnum) form-vec)))
(defun form-for-int (bits i)
  (const-form (make-int-bits i bits)))

(declaim (ftype (function (mem form-vec (cons (cons formula fixnum) list)) mem) simplify-set))
(defun simplify-set (mem val cv-pairs)
  (let* ((nw (mem-num-words mem))
	 (ws (mem-wordsize mem))
	 (nmem (new-mem nw ws)))
    (dotimes (i nw) (mem-set-word nmem i (mem-get-word mem i)))
    (dolist (cv cv-pairs nmem)
      (mem-set-word nmem (cdr cv) (ps-if-form (list (car cv) val (mem-get-word mem (cdr cv))))))))

;;;union-find;;;

(defmacro parent (form)
  `(the formula (car (formula-slot1 ,form))))

(defmacro rank (form)
  `(the fixnum (cdr (formula-slot1 ,form))))

(declaim (ftype (function (formula) formula) make-set))
(defun make-set (form)
  (setf (formula-slot1 form) (cons form 0))
  form)

(declaim (ftype (function (formula) formula) find-set))
(defun find-set (x)
  (if (eq x (parent x))
      x
    (setf (parent x) (find-set (parent x)))))

(declaim (ftype (function (formula formula) formula) union-sets))
(defun union-sets (form1 form2)
  (let ((fs1 (find-set form1))
	(fs2 (find-set form2)))
    (cond ((eq fs1 fs2) fs1)
	  ((< (rank fs2) (rank fs1))
	   (setf (parent fs2) fs1))
	  (t
	   (when (= (rank fs2) (rank fs1)) (incf (rank fs2)))
	   (setf (parent fs1) fs2)))))

(declaim (ftype (function (formula formula) formula) combine-mecs))
(defun combine-mecs (mec1 mec2)
  (if (eq mec1 mec2)
      mec1
    (let ((gs1 (formula-slot2 mec1))
	  (gs2 (formula-slot2 mec2))
	  (mec (union-sets mec1 mec2)))
      (setf (formula-slot2 mec1) nil)
      (setf (formula-slot2 mec2) nil)
      (setf (formula-slot2 mec) 
	    (append gs1 gs2))
      mec)))

(declaim (ftype (function (formula) formula) mec-mems))
(defun mec-mems (form)
  (cond ((eq (formula-fn form) 'var) (find-set form))
	((formula-slot1 form) (the formula (formula-slot1 form)))	
	(t
	 (setf (formula-slot1 form)
	       (let ((args (formula-args form)))
		 (case (formula-fn form)
		   (set (mec-bvs (second args))
			(mec-bvs (third args))
			(let ((m (mec-mems (first args))))
			  (setf (formula-slot2 m) (cons form (formula-slot2 m)))
			  m))
		   (if (mec-bvs (first args))
		       (combine-mecs (mec-mems (second args))
				     (mec-mems (third args))))	   
		   (otherwise (break (format nil "~&unexpected function: ~A~%" (formula-fn form))))))))))

(declaim (ftype (function (form-vec) null) mec-bvs))
(defun mec-bvs (form)
  ;;(declare (type formula form))
  (cond ((vec-p form)
	 (dotimes (i (vec-num-bits form))
	   (mec-bvs (vec-get-bit form i))))
	((formula-slot1 form) t)
	(t
	 (setf (formula-slot1 form) t)
	 (let ((args (formula-args form)))
	   (case (formula-fn form)
	      (const nil)
	      (var nil)
	      (bit (mec-bvs (first args)))
	      (get (mec-bvs (second args))
		   (let ((m (mec-mems (first args))))
		     (setf (formula-slot2 m) (cons form (formula-slot2 m)))))
	      (= (combine-mecs (mec-mems (first args))
			       (mec-mems (second args))))
	      (otherwise (mapcar #'mec-bvs (formula-args form)))))))
  nil)


(defstruct mec-info
  (mems nil :type list)
  (accesses nil :type list)
  (addr-multiset nil :type list))

(declaim (ftype (function (list) list) mec-compute-addr-multiset))
(defun mec-compute-addr-multiset (accesses)
  (loop for a of-type formula in accesses
	for addr of-type form-vec = (second (formula-args a))
	for elt of-type (cons form-vec fixnum) = (assoc addr am)
	if elt do (incf (cdr elt))
	else collect (cons addr 1) into am
	finally (return (sort am #'> :key #'cdr))))

(declaim (ftype (function (form-vec list) list) mec))
(defun mec (form mems)
  (dolist (mem mems) (make-set mem))
  (mec-bvs form)
  (loop for mem of-type formula in mems
	for p of-type formula = (find-set mem)
	for mt of-type (cons formula mec-info) = (assoc p mec-alist :test 'eq)
	if mt do (setf (mec-info-mems (cdr mt))
		       (cons mem (mec-info-mems (cdr mt))))
	else collect (cons p
			   (make-mec-info :mems (list mem)
					  :accesses (formula-slot2 p)
					  :addr-multiset (mec-compute-addr-multiset (formula-slot2 p))))
	             into mec-alist
             and do (setf (formula-slot2 p) nil)
        finally (progn (clear-slot1 form)
		       (return (mapcar #'cdr mec-alist)))))

;;   (let ((mec-alist nil))
;;     (dolist (mem mems)
;;       (let* ((p (find-set mem))
;; 	     (mt (assoc p mec-alist :test 'eq)))
;; 	(cond (mt (setf (mec-info-mems (cdr mt))
;; 			(cons mem (mec-info-mems (cdr mt)))))
;; 	      (t
;; 	       (setf mec-alist
;; 		     (acons p
;; 			    (make-mec-info :mems (list mem)
;; 					   :accesses (formula-slot2 p)
;; 					   :addr-multiset (mec-compute-addr-multiset (formula-slot2 p)))
;; 			    mec-alist))
;; 	       (setf (formula-slot2 p) nil)))))
;;     (clear-slot1 form)
;;     (mapcar #'cdr mec-alist)))

;; (defun prop-addrs (mems)
;;   (cond ((endp mems) t)
;; 	(t
;; 	 (let ((x (find-set (car mems))))
;; 	   (unless (eq x (car mems))
;; 	     (setf (formula-slot2 x)
;; 		   (union (formula-slot2 x)
;; 			  (formula-slot2 (car mems))
;; 			  :test 'eq))))
;; 	 (prop-addrs (cdr mems)))))

;; (defun print-mec-outcomes (addr-alist)
;;   (mapcar (lambda (x)
;; 	    (format t "~&mem: ~A, accesses: ~A~%"
;; 		    (car x)
;; 		    (length (cdr x))))
;; 	  addr-alist))

;; (defun form-vals (fv)
;;   (if (formula-p fv)
;;       (formula-value fv)
;;     (let ((pv (make-array (vec-num-bits fv) :element-type 'fixnum :initial-element 0)))
;;       (dotimes (i (vec-num-bits fv) pv)
;; 	(setf (aref pv i) (form-vals (aref fv i)))))))

(declaim (ftype (function (list) null) print-mec-outcomes))
(defun print-mec-outcomes (mecs)
  (dolist (x mecs)
    (format t "~&mem equivalence class: ~A~%total unique reads/writes: ~A~%"
	    (mapcar (lambda (y) (car (formula-args y))) 
		    (mec-info-mems x))
	    (length (mec-info-addr-multiset x)))))

(declaim (ftype (function (list) hash-table) red-addr-constrs))
(defun red-addr-constrs (an-pairs)
  (let* ((aarray (coerce (sortforms (mapcar #'car an-pairs)) '(vector form-vec)))
	 (na (array-dimension aarray 0))
	 (chash (make-hash-table :test 'eq :size na)))
     (loop for i from 0 below na
	  for addr of-type form-vec = (aref aarray i)
	  do (setf (gethash addr chash)
		   ;;(red-addr-constrs1 addr i 0 aarray nil nil))
		   (loop for j from 0 below i
			 for eform = (equals-form (list addr (aref aarray j)))
			 for neform = (sb-not-form eform)
			 when (eq eform *one*) return `((,*one* . ,j))
			 unless (eq neform *one*)
			    collect (cons (sb-and-form (cons eform neforms)) j) into constrs
			    and collect neform into neforms
			 finally (return (if (eq constrs nil)
					     `((,*one* . ,i))
					   (acons (sb-and-form neforms) i constrs)))))
	  finally (return chash))))

(declaim (ftype (function (form-vec) boolean) const-form-vec-p))
(defun const-form-vec-p (fv)
  (dotimes (i (vec-num-bits fv) t)
    (unless (eq (formula-fn (get-bit fv i)) 'const) (return nil))))

(declaim (ftype (function (form-vec) fixnum) const-to-int))
(defun const-to-int (fv)
  (loop for i to (1- (vec-num-bits fv))
	when (eq (get-bit fv i) *one*)
	   sum (expt 2 i)))

(declaim (ftype (function (list fixnum) hash-table) addr-constrs))
(defun addr-constrs (an-pairs nw)
  (loop with chash = (make-hash-table :test 'eq :size nw)
	with bits = (vec-num-bits (caar an-pairs))
	for an in an-pairs
	for addr = (car an)
	if (const-form-vec-p addr)
	do (setf (gethash addr chash)
		 `((,*one* . ,(const-to-int addr))))
	else
	do (setf (gethash addr chash)
		 (loop for i from 0 below nw
		       for eform = (ps-equals-form (list addr (form-for-int bits i)))
		       unless (eq eform *zero*) collect (cons eform i)))
	finally (return chash)))

(declaim (ftype (function (formula fixnum) mem) mem-form))
(defun mem-form (mem nw)
  (let* ((args (formula-args mem))
	 (ws (third (formula-type mem)))
	 (nmem (new-mem nw ws))
	 (k -1))
    (dotimes (i nw nmem)
      (dotimes (j ws)
	(mem-set-bit nmem i j
		     (make-unique-formula :fn 'var :args (list (car args) 0 (incf k))))))))

;; (declaim (ftype (function (list list list) (values list list)) vars-mems1))
;; (defun vars-mems1 (mixed vars mems)
;;   (cond ((endp mixed) (values vars mems))
;; 	((eq (car (formula-type (car mixed))) 'mem)
;; 	 (vars-mems1 (cdr mixed) vars (cons (car mixed) mems)))
;; 	(t
;; 	 (vars-mems1 (cdr mixed) (cons (car mixed) vars) mems))))

(declaim (ftype (function (list) (values list list)) vars-mems))
(defun vars-mems (mixed)
  (loop for m of-type formula in mixed
	if (eq (car (formula-type m)) 'mem)
          collect m into mems
        else
          collect m into vars
        finally (return (values vars mems))))

(declaim (ftype (function (list list) (values list list)) mem-extensions))
(defun mem-extensions (mecs vars)
  (let ((m2e nil)
	(nvars vars))
    (dolist (mec mecs (values m2e nvars))
      (if (endp (cdr mec))
	  (setf m2e (acons (car mec) *zero* m2e))
	(let ((bits (ceil-log (length mec))))
	  (dolist (mem mec)
	    (let ((vname (read-from-string (format nil "_T~A" (incf *tvars*))))
		  (step (second (formula-args mem))))
		(cond ((= bits 1)
		       (let ((nvar (make-unique-formula :fn 'var :args (list vname step 0))))
			 (setf nvars (cons nvar nvars))
			 (setf m2e (acons mem nvar m2e))))
		      (t
		       (let ((vec (new-vec bits)))
			 (dotimes (i bits)
			   (let ((v (make-unique-formula :fn 'var :args (list vname step i))))
			     (vec-set-bit vec i v)
			     (setf nvars (cons v nvars))))
			 (setf m2e (acons mem (make-unique-vec vec) m2e))))))))))))

(declaim (ftype (function (formula list) formula) me-form))
(defun me-form (form m2e)
  (if (formula-slot2 form)
      (the formula (formula-slot2 form))
    (setf (formula-slot2 form)
	  (case (formula-fn form)
	    (var (the formula (cdr (assoc form m2e))))
	    (set (me-form (first (formula-args form)) m2e))
	    (if  (let* ((args (formula-args form))
			(me1 (me-form (second args) m2e))
			(me2 (me-form (third args) m2e)))
		   (if (eq me1 me2) me1 (ps-if-form (list (first args) me1 me2)))))
	    (otherwise (break (format nil "unexpected form in me-form: ~A"
				      (formula-fn form))))))))

(declaim (ftype (function (formula formula boolean) (values formula boolean))))
(defun cp-return (form nform cp)
  (setf (formula-slot1 form) (cons nform cp))
  (values nform cp))

(declaim (ftype (function (list list) (values list boolean)) ime1-list))
(defun ime1-list (lst m2e)
  (let* ((cp nil)
	 (nlst (mapcar (lambda (form)
			 (if (formula-p form)
			     (multiple-value-bind
				 (nform cp0)
				 (insert-mem-extensions1 form m2e)
			       (when (and (not cp) cp0) (setf cp t))
			       nform)
			   form))
			 lst)))
    (values nlst cp)))
	   
(declaim (ftype (function (formula list) (values formula boolean)) insert-mem-extensions1)) 
(defun insert-mem-extensions1 (form m2e)
  (if (formula-slot1 form)
      (values (car (formula-slot1 form)) (cdr (formula-slot1 form)))
    (case (formula-fn form)
      (const (cp-return form form nil))
      (var (cp-return form form nil))
      (= (multiple-value-bind
	     (nargs cp)
	     (ime1-list (formula-args form) m2e)
	   (let ((me1 (me-form (first nargs) m2e))
		 (me2 (me-form (second nargs) m2e)))
	     (cond ((not (eq me1 me2))
		    (cp-return form
			       (and-form (list (ps-equals-form (list me1 me2))
					       (if cp (ps-equals-form nargs) form)))
			       t))
		   (cp
		    (cp-return form (ps-equals-form nargs) t))
		   (t
		    (cp-return form form nil))))))
      (otherwise
       (multiple-value-bind
	   (nargs cp)
	   (ime1-list (formula-args form) m2e)
	 (if cp
	     (cp-return form
			(make-unique-formula :fn (formula-fn form)
					     :type (formula-type form)
					     :args nargs)
			t)
	   (cp-return form form nil)))))))
		
(declaim (ftype (function (formula list) formula) insert-mem-extensions))				  
(defun insert-mem-extensions (form m2e)
  (multiple-value-bind
      (nform cp)
      (insert-mem-extensions1 form m2e)
    (declare (ignore cp))
    (clear-both-slots form)
    nform))

(declaim (ftype (function (formula list) (values formula list list list)) sm-prep))
(defun sm-prep (form mixed)
  (multiple-value-bind
      (vars mems)
      (vars-mems mixed)
    (let ((mecs (mec form mems)))
      (print-mec-outcomes mecs)
      (multiple-value-bind
	  (m2e vars)
	  (mem-extensions (mapcar #'mec-info-mems mecs) vars)
	(let ((nform (insert-mem-extensions form m2e)))
	  (let ((aaalist nil)
		(mac-alist nil)) ;; alist mapping memory-address pairs to constraints.
	    (dolist (mec mecs (values nform aaalist mac-alist vars))
	      (let* ((addrs (mec-info-addr-multiset mec))
		     (na (length addrs))
		     (mems (mec-info-mems mec))
		     (mem1 (car mems))
		     (tp (formula-type mem1))
		     (nw (second tp))
		     ;;(ws (third tp))
		     (accesses (mec-info-accesses mec))
		     (p (<= na nw));;(< (* na (ceil-log na)) (* (- nw na) ws)))
		     (nms (if p na nw))
		     (chash (if p (red-addr-constrs addrs) (addr-constrs addrs nw))))
		(format t "~A: ~A~%" (mapcar (lambda (x) (first (formula-args x))) mems) p)
		(dolist (mem mems)
		  (let* ((args (formula-args mem))
			 (mform (mem-form mem nms)))
		    (dotimes (i (mem-num-words mform))
		      (dotimes (j (mem-wordsize mform))
			(setf vars (cons (mem-get-bit mform i j) vars))))
		    (setf (formula-slot1 mem) (cons mform t))
		    (setf mac-alist (acons (cons (first args) (second args))
					   (cons mform chash)
					   mac-alist))))
		(dolist (a accesses)
		  (setf aaalist (acons a
				       (the cons (gethash (second (formula-args a)) chash))
				       aaalist)))))))))))

;; (defun sm-prep (form mixed)
;;   (multiple-value-bind
;;       (vars mems)
;;       (vars-mems mixed)
;;     (let ((mecs (mec form mems)))
;;       (print-mec-outcomes mecs)
;;       (multiple-value-bind
;; 	  (m2e vars)
;; 	  (mem-extensions (mapcar #'mec-info-mems mecs) vars)
;; 	(let ((nform (insert-mem-extensions form m2e)))
;; ;;;	  (dolist (var vars) (setf (formula-slot1 var) (cons var nil)))
;; 	  (let ((aaalist nil)
;; 		(constrs nil)
;; 		(oa-na-pairs nil)
;; 		(m-oa-na-alist nil))
;; 	    (dolist (mec mecs (values (and-form (cons nform constrs))
;; 				      aaalist m-oa-na-alist vars))
;; 	      (let* ((addrs (mec-info-addr-multiset mec))
;; 		     (na (length addrs))
;; 		     (mems (mec-info-mems mec))
;; 		     (mem1 (car mems))
;; 		     (tp (formula-type mem1))
;; 		     (nw (second tp))
;; 		     (ws (third tp))
;; 		     (accesses (mec-info-accesses mec)))
;; 		(cond ((< (* na (ceil-log na)) (* (- nw na) ws)) ;;TODO: more accurate measure.
;; 		       (setf (values oa-na-pairs constrs vars)
;; 			     (new-addrs addrs
;; 					na
;; 					vars
;; 					constrs))
;; 		       (red-addr-constrs addrs)
;; 		       (dolist (mem mems)
;; 			 (let* ((args (formula-args mem))
;; 				(mform (mem-form mem na)))
;; 			   (dotimes (i (mem-num-words mform))
;; 			     (dotimes (j (mem-wordsize mform))
;; 			       (setf vars (cons (mem-get-bit mform i j) vars))))
;; 			   (setf (formula-slot1 mem) (cons mform t))
;; 			   (setf m-oa-na-alist (acons (cons (first args) (second args))
;; 						      (cons mform 
;; 							    (mapcar (lambda (x)
;; 								      (cons (car x) (cadr x)))
;; 								    oa-na-pairs))
;; 						      m-oa-na-alist))))
;; 		       (dolist (a accesses)
;; 			 (setf aaalist (acons a
;; 					      (cdr (assoc (second (formula-args a))
;; 							  oa-na-pairs))
;; 					      aaalist))))
;; 		      (t
;; 		       (dolist (mem mems)
;; 			 (let ((args (formula-args mem))
;; 			       (mform (mem-form mem nw)))
;; 			   (setf (formula-slot1 mem) (cons mform t))
;; 			   (dotimes (i (mem-num-words mform))
;; 			     (dotimes (j (mem-wordsize mform))
;; 			       (setf vars (cons (mem-get-bit mform i j) vars))))
;; 			   (let ((oa-na-pairs (mapcar (lambda (x)
;; 							(cons (car x) (cons (car x) (1- nw))))
;; 						      addrs)))
;; 			     (setf m-oa-na-alist (acons (cons (first args) (second args))
;; 							(cons mform 
;; 							      (mapcar (lambda (x)
;; 									(cons (car x) (cadr x)))
;; 								      oa-na-pairs))
;; 							m-oa-na-alist))
;; 			     (dolist (a accesses)
;; 			       (setf aaalist (acons a
;; 						    (cdr (assoc (second (formula-args a))
;; 								oa-na-pairs))
;; 						    aaalist))))))))))))))))
		
(declaim (ftype (function (form-vec list) list) vars-in-form1))
(defun vars-in-form1 (form vars)
  (cond ((vec-p form)
	 (let ((nvars vars))
	   (dotimes (i (vec-num-bits form) nvars)
	     (setf nvars (vars-in-form1 (vec-get-bit form i) nvars)))))
	((not (and (formula-p form)
		   (not (formula-slot1 form))))
	 vars)
	((eq (formula-fn form) 'var)
	 (setf (formula-slot1 form) t)
	 (cons form vars))
	(t
	 (setf (formula-slot1 form) t)
	 (let ((vars vars))
	   (dolist (arg (formula-args form) vars)
	     (when (typep arg 'form-vec)
	       (setf vars (vars-in-form1 arg vars))))))))

(declaim (ftype (function (form-vec) list) vars-in-form))
(defun vars-in-form (form)
  (let ((vars (vars-in-form1 form nil)))
    (clear-slot1 form)
    vars))
						   
(declaim (ftype (function (list list) (values list boolean)) simplify-memories1-list))
(defun simplify-memories1-list (lst aaalist)
  (if (endp lst)
      (values nil nil)
    (multiple-value-bind
      (nlst has-mem?)
      (simplify-memories1-list (cdr lst) aaalist)
      (if (typep (car lst) 'form-vec-mem)
	  (multiple-value-bind
	      (nform has-mem0?)
	      (simplify-memories1 (car lst) aaalist)
	    (values (cons nform nlst) (or has-mem0? has-mem?)))
	(values (cons (car lst) nlst) has-mem?)))))

;; (defun print-ca-info (calist)
;;   (loop for c of-type (cons formula fixnum) in calist
;; 	if (eq (formula-fn (car c)) 'const)
;; 	  do (format t "~A: ~A~%" (car (formula-args (car c))) (cdr c))
;; 	else if (= (cdr c) 0)
;; 	  do (format t "~A: 0~%" (formula-value (car c)))	       
;;         else
;;           do (format t "(and ~{~A~}): ~D~%"
;; 		     (mapcar #'formula-value (formula-args (car c)))
;; 		     (cdr c))))

(declaim (ftype (function (list list) list) simplify-memories-ca))
(defun simplify-memories-ca (calist aaalist)
  (loop for c of-type (cons formula fixnum) in calist
	collect (cons (simplify-memories1 (car c) aaalist)
		      (cdr c))))



(declaim (ftype (function (form-vec list) (values form-vec-mem boolean)) simplify-memories1))
(defun simplify-memories1 (form aaalist)
  (cond ((vec-p form)
	 (let ((hm? nil)
	       (vec (new-vec (vec-num-bits form))))
	   (dotimes (i (vec-num-bits form) (values (if hm? (make-unique-vec vec) form) hm?))
	     (multiple-value-bind
		 (arg has-mem?)
		 (simplify-memories1 (vec-get-bit form i) aaalist)
	       (or hm? (setf hm? has-mem?))
	       (vec-set-bit vec i arg)))))
;; 	((not (formula-p form)) 
;; 	 (values form nil))
	((formula-slot1 form)
	 (unless (typep (car (formula-slot1 form)) 'form-vec-mem) (break))
	 (values (car (formula-slot1 form)) 
		 (cdr (formula-slot1 form))))
	(t
	 ;;(format t "~&~A ~A~%" (formula-fn form) (formula-value form))
	 (multiple-value-bind
	   (args has-mem?)
	   (simplify-memories1-list (formula-args form) aaalist)
	   (multiple-value-bind
	     (nform has-mem0?)
	     (case (formula-fn form)
	       (const (values form nil))
	       (var (values form nil))
	       (get (let* ((cv-pairs (simplify-memories-ca (cdr (assoc form aaalist :test 'eq))
							   aaalist))
			   (sg (simplify-get (first args) (third args) cv-pairs)))
		      (values sg t)))
	       (set (let* ((cv-pairs (simplify-memories-ca (cdr (assoc form aaalist :test 'eq))
							   aaalist))
			   (ss (simplify-set (first args) (third args) cv-pairs)))
		      (values ss t)))
	       (if  (values (ps-if-form args) t))
	       (=   (values (ps-equals-form args) t))
	       (bit (values (get-bit (first args) (second args)) has-mem?))
	       (and (values (if has-mem? (and-form args) form) has-mem?))
	       (not (values (if has-mem? (not-form (car args)) form) has-mem?))
	       (<-> (values (if has-mem? (equiv-form args) form) has-mem?))
	       (otherwise (break (format nil "~&simplify-memories1: unexpected function: ~a~%" form))
			  (make-formula)))
	     (setf (formula-slot1 form) (cons nform has-mem0?))
	     (values nform has-mem0?))))))

(declaim (ftype (function (formula) (values formula list list)) simplify-memories))
(defun simplify-memories (form)
  (scrub-slots form)
  (multiple-value-bind
      (vars mems)
      (vars-mems (vars-in-form form))
    (cond ((or (eq (formula-fn form) 'const)
	       (endp mems))
	   (values form vars))
	  (t
	   ;; (find-slot-residue form)
	   (let* ((form (if (member *ap* '(mem t)) (and-propagation form) form))
		  (form (if *rp* (mem-rewrite form) form))
		  (vars (vars-in-form form)))
	     (setf *tvars* -1)
	     (multiple-value-bind
		 (nform aaalist mac-alist nvars)
		 (sm-prep form vars)
	       (setf *constrs* nil)
	       (setf *vars* nvars)
	       (let* ((ans (if (eq (formula-fn nform) 'const)
			       nform
			     (sb-and-form (cons (simplify-memories1 nform aaalist)
						*constrs*)))))
		 (dolist (mac mac-alist)
		   (loop with chash = (cddr mac)
			 for k being the hash-key using (hash-value v) of chash
			 collect (cons (simplify-memories1 k aaalist)
				       (simplify-memories-ca v aaalist))
		         into nprs
			 finally (progn (clrhash chash)
					(loop for pr in nprs
					      do (setf (gethash (car pr) chash)
						       (cdr pr))))))
		 (dolist (mac mac-alist)
		   (maphash (lambda (k v)
			      (clear-slot1 k)
			      (mapcar (lambda (x) (clear-slot1 (car x))) v))
			    (cddr mac)))
		 (scrub-slots ans)
		 (clear-var-slots vars)
		 (clrhash *fhash*)
		 (values ans (the list *vars*) mac-alist))))))))
